
var session_info = getPOTASettings();
var potaSettings = session_info.potaSettings;
var TOKEN = session_info.apiToken;
var THEMECLASS = potaSettings.darkMode ? 'theme--dark' : 'theme--light';
var MYCALL = potaSettings.callsign;
console.log("MYCALL: ", MYCALL);

sendChromeMessage("set__MYCALL", MYCALL);
sendChromeMessage("set__TOKEN", TOKEN);

var POTA_API_OPTS = {
  headers: {
	  authorization: TOKEN
	, origin: "https://pota.app"
	, accept: "application/json, text/plain, */*"
  }
};

var CELLS = Array.from( document.querySelectorAll('.col-sm-4', '.col-md-3', '.col-lg-2', '.col-xl-1', '.col-6') );
var MAINTABLE = CELLS[0] && CELLS[0].parentElement;
var DARKMODE = MAINTABLE.closest("div.theme--dark") ? true : false;


var PROFILE_CALL = '';
PROFILE_CALL = document.location.hash.match(/#\/profile\/(.+)/)[1];

var MYAWARDS_EARNED = null;
var PROFILE_INFO = null;


if( MYCALL){
  ////////
  chrome.runtime.sendMessage({ message: "get__MYAWARDS_EARNED_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
      MYAWARDS_EARNED = cache ? JSON.parse(cache.data) || {} : {};
      MAINTABLE.append(" "); // touch, to trigger initial update
    }
  });  // get__MYAWARDS_EARNED_cache
  ////////
    fetch('https://api.pota.app/profile/' + PROFILE_CALL, POTA_API_OPTS)
    .then(response => response.json())
    .then(data => {
		PROFILE_INFO = data;
		MAINTABLE.append(" "); // touch, to trigger initial update
/*
awards[ {}, ... ]
    "name": "Bronze Activator",
    "granted": "2021-08-04T17:18:19",
    "endorsements": [ "15M", "40M", "DATA", "PHONE" ]
*/
    }); // fetch
  ////////
} // if MYCALL




var observer;
if( observer == null ){
observer = new MutationObserver(mutations => {
    if( document.location.hash == "#/" ){
	console.log("Switched to SPOTS page");
	document.location.reload();
	return;
    }
    if( document.location.hash == "#/activations" ){
	console.log("Switched to ACTIVATIONS page");
	document.location.reload();
	return;
    }
    if( ! document.location.hash.match("#/profile/.+") ){
	console.log("NO LONGER ON PROFILE PAGE");
	return;
    }
    if( false
		|| MYAWARDS_EARNED == null
		|| PROFILE_INFO == null
    	){
	    // skip while still loading/initializing the async-fetch of dependencies
	    console.log("LOADING:"
		, 'MYAWARDS_EARNED: '   + (MYAWARDS_EARNED   ? 'Y' : '-')
		, 'PROFILE_INFO: '      + (PROFILE_INFO      ? 'Y' : '-')
	    );
	    return;
    }

    observer.disconnect(); // turn observer off;


    for (let cell of CELLS) {
	    if( cell.innerHTML.match(/AWARD_DETAILS/) ){
		    continue;
	    }
	    var awardNameObj = cell.querySelector('p');
	    if( ! awardNameObj ){
		    continue;
	    }
	    var awardName = awardNameObj.innerText;
	    var awardInfo = PROFILE_INFO.awards.find( e => e.name == awardName );
	    if( ! awardInfo ){
		    continue;
	    }
	    var x = document.createElement('div');
	    x.setAttribute('data-marker','AWARD_DETAILS');
	    x.innerHTML = `
	    	${awardInfo.granted.replace(/-\d\dT.+/,'')} <br/>
		${awardInfo.endorsements.join(", ")}
	    `;
	    awardNameObj.append(x);
    } // let cell

    ///////////////////////////////////////

//-------------------------------------

    observe(); // turn back on 
}); // new MutationObserver
}

var observe = ()=> {
  observer.observe(MAINTABLE, {
    childList: true,
    characterData: true,
    subtree: true,
  });
};
observe();
MAINTABLE.append(" "); // touch, to trigger initial update

