
var MYCALL;
var TOKEN;
var POTA_API_OPTS;

function copyToClipBoard(elementId){
    var content = document.getElementById(elementId).innerHTML;

    navigator.clipboard.writeText(content)
        .then(() => {
//        console.log("Text copied to clipboard...");
	alert("Copied to Clipboard.");
    })
        .catch(err => {
        console.log('Something went wrong', err);
    })
 
}

document.getElementById('n1cc_activator__btn').addEventListener('click', (e) => {
  copyToClipBoard('n1cc_activator__export');
});
document.getElementById('n1cc_hunter__btn').addEventListener('click', (e) => {
  copyToClipBoard('n1cc_hunter__export');
});
document.getElementById('op2op__btn').addEventListener('click', (e) => {
  copyToClipBoard('op2op__export');
});
document.getElementById('earned__btn').addEventListener('click', (e) => {
  copyToClipBoard('earned__export');
});
document.getElementById('earned__btnjson').addEventListener('click', (e) => {
  copyToClipBoard('earned__exportjson');
});
document.getElementById('my_activations__btn').addEventListener('click', (e) => {
  copyToClipBoard('my_activations__export');
});
document.getElementById('my_activations__btnjson').addEventListener('click', (e) => {
  copyToClipBoard('my_activations__exportjson');
});


/////////////////////////////////////////////////////////
async function updateBandsWorked(flag, page, park_num, entry){
	    var size = 100; // seems like size=100 is the max
	    var url = `https://api.pota.app/user/logbook?${flag}=1&page=${page}&size=${size}&reference=${park_num}`;
	    if( page == 1 ){
		entry.bandsWorked = {};
		entry.bandsWorkedStr = '';
	    }
	    if( Object.keys( entry.bandsWorked ).length == entry.bands ){
		// bail if found the number of bands. hopefully short-circuits going through long activator logs.
		return entry;
	    }
	    return fetch(url, POTA_API_OPTS)
	    .then(response => response.json())
	    .then(data => {
		Array.from( data.entries ).forEach( (s) => {
		  if( s.reference == park_num ){ // sanity-check against false-positive search matches
		    if( s.band.toUpperCase() != "INVALID" ){
		      entry.bandsWorked[ s.band.toUpperCase() ] = s.qsoId; // store id, for a little bit more info than a boolean
		      entry.bandsWorkedStr = Object.keys(entry.bandsWorked)
			.sort( (a,b) => compareBands(a,b) )
			.join(',');
		    }
		  }
		});
		if( data.entries.length && data.count > page*size ){
		  return updateBandsWorked(flag, page+1, park_num, entry);
		}
		return entry;
	    });
}
/////////////////////////////////////////////////////////
function displayMY_ACTIVATIONS( divID, rows ){
	var div = document.getElementById(divID);
	div.innerHTML = 'No activations'; // TODO  "Ensure that option ____ is on"
	var divExport = document.getElementById(divID+'__export');
	divExport.innerHTML = '';
	var divExportJSON = document.getElementById(divID+'__exportjson');
	divExportJSON.innerText = JSON.stringify( rows );
	if( rows && rows.length ){
	    div.innerHTML = '';
	    var cols = [
		      "date"
		    , "callsign"
		    , "reference"
		    , "name"
		    , "parktypeDesc"
		    , "locationDesc"
		    , "total"
		    , "phone"
		    , "cw"
		    , "data"
	    ];
	    div      .append( cols.join("\t") + "\n" );
	    divExport.append( cols.join(",")  + "\n" );
	    rows.forEach( (row) => {
			var values = cols.map( (s) => row[s] );
	    		div      .append( values.join("\t") + "\n" );
			divExport.append( values.map(s=> s!=null && s.toString().match(/,/) ? `"${s}"` : s ).join(",")  + "\n" );
	    });
	}
}
/////////////////////////////////////////////////////////
function displayN1CC( divID, rows ){
	var div = document.getElementById(divID);
	div.innerHTML = 'No candidates (need at least 3 bands worked)';
	var divExport = document.getElementById(divID+'__export');
	divExport.innerHTML = '';
	if(! rows.length){
		return;
	}
	var bandsSeen = {};
	rows.forEach( (entry) => {
		Object.keys( entry.bandsWorked ).forEach( k => { bandsSeen[k] = 1 } );
	});
	var bandCols = Object.keys( bandsSeen ).sort();
	div.innerHTML = '';
	var cols = ["ParkRef", "#Bands", "Bands", "", "Park Name"];
	div      .append( cols.join("\t") + "\n" );
	divExport.append( cols.concat(bandCols).join(",")  + "\n" );
	rows.forEach( (entry) => {
		var values = [
			entry.reference
			, "x" + entry.bands
			, entry.bandsWorkedStr
			, entry.name
		];
		div      .append( values.join("\t") + "\n" );
		var bandValues = bandCols.map( k => entry.bandsWorked[k] ? 1 : '' );
		divExport.append( values.concat(bandValues).map(s=> s.toString().match(/,/) ? `"${s}"` : s ).join(",")  + "\n" );
	});
}
var PROGRESS_CTS = {
	activator: { ct: 0, total: 0 },
	hunter:    { ct: 0, total: 0 },
};
async function updateBandsWorkedAsync (flag, page, park_num, entry) {
  return Promise.resolve( updateBandsWorked(flag, page, park_num, entry) );
}
async function processN1CC( logType, N1CC_DATA ){
	var progressKey = logType.replace("Only","");
	PROGRESS_CTS[progressKey].total = N1CC_DATA.length;
	return Promise.all(
	    N1CC_DATA
	      .sort( (a,b) => { var aa=a.bands; var bb=b.bands; return aa<bb?1 : aa==bb ? 0 : -1 } ) // ORDER BY #Bands DESC
	      .map( entry => updateBandsWorkedAsync(logType,1, entry.reference, entry)
		.then(x=>{ document.getElementById('n1cc_'+progressKey).innerHTML = `Processed ${++PROGRESS_CTS[progressKey].ct} / ${PROGRESS_CTS[progressKey].total} parks`; return x})  //  update a progress label
	      )
	);
}

function init(){
  if( ! MYCALL || ! TOKEN || ! POTA_API_OPTS ){
	    return; // pre-reqs not loaded yet
  }
  //////////////////////
/*
  chrome.runtime.sendMessage({ message: "get__N1CC_HUNTER_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
//cache=null; //  DEBUG
      if( cache && cache.data && cache.updated && youngerThan(cache.updated,20)){
	var N1CC_DATA = cache.data;	// use cached
	displayN1CC('n1cc_hunter', N1CC_DATA);
	return;
      }
    }
    // refresh from pota.app API
    fetch('https://api.pota.app/user/award/progress/hunter/n1ccmultiband', POTA_API_OPTS)
    .then(response => response.json())
    .then(data => {
	var N1CC_DATA = Array.from( data );
	processN1CC('hunterOnly', N1CC_DATA).then( data => {
		chrome.runtime.sendMessage({ message: "set__N1CC_HUNTER_cache",  payload: {updated:Date.now(), data:data}  }, response => { if(response.message === 'success'){} });
		displayN1CC('n1cc_hunter', data);
	} );
    }); // fetch
  });  // get__N1CC_HUNTER_cache
*/
  chrome.runtime.sendMessage({ message: "get__N1CC_HUNTED_cache" }, response => {
    if (response.message === 'success') {
	var cache = response.payload;
	var N1CC_DATA = cache.data;
	displayN1CC('n1cc_hunter', N1CC_DATA);
	return;
    }
  });  // get__N1CC_HUNTED_cache
  //////////////////////
  chrome.runtime.sendMessage({ message: "get__N1CC_ACTIVATOR_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
//cache=null; //  DEBUG
      if( cache && cache.data && cache.updated && youngerThan(cache.updated,20)){
	var N1CC_DATA = cache.data;	// use cached
	displayN1CC('n1cc_activator', N1CC_DATA);
	return;
      }
    }
    // refresh from pota.app API
    fetch('https://api.pota.app/user/award/progress/activator/n1ccmultiband', POTA_API_OPTS)
    .then(response => response.json())
    .then(data => {
	var N1CC_DATA = Array.from( data );
	processN1CC('activatorOnly', N1CC_DATA).then( data => {
		chrome.runtime.sendMessage({ message: "set__N1CC_ACTIVATOR_cache",  payload: {updated:Date.now(), data:data}  }, response => { if(response.message === 'success'){} });
		displayN1CC('n1cc_activator', data);
	} );
    }); // fetch
  });  // get__N1CC_ACTIVATOR_cache
  //////////////////////
  chrome.runtime.sendMessage({ message: "get__MY_ACTIVATIONS_cache" }, response => {
    if (response && response.message === 'success') {
      var cache = response.payload;
      if( cache && cache.data && typeof(cache.data) == "object" && cache.updated && youngerThan(cache.updated,20)){
	displayMY_ACTIVATIONS('my_activations', cache.data.activations);
	return;
      }
    }
    fetch('https://api.pota.app/user/activations?all=1', POTA_API_OPTS)
    .then(response => response.json())
    .then(data => {
	chrome.runtime.sendMessage({ message: "set__MY_ACTIVATIONS_cache",  payload: {
		updated:Date.now()
		// , data:data
		, data:null // don't cache, since issues with "QUOTA_BYTES quota exceeded". but it's a fast API call, so ok to be live data.
	}  }, response => { if(response.message === 'success'){} });
	displayMY_ACTIVATIONS('my_activations', data.activations);
    }); // fetch
  });  // get__MY_ACTIVATIONS_cache
  //////////////////////
}


///////////////////////////////
// main()
///////////////////////////////
chrome.runtime.sendMessage({ 
        message: "get__MYCALL"
      }, response => {
      if (response.message === 'success') {
	MYCALL = response.payload;
	init();
      }
});
chrome.runtime.sendMessage({ 
        message: "get__TOKEN"
      }, response => {
      if (response.message === 'success') {
	TOKEN = response.payload;
	POTA_API_OPTS = {
	  headers: {
		  authorization: TOKEN
		, origin: "https://pota.app"
		, accept: "application/json, text/plain, */*"
	  }
	};
	init();
      }
});
var OPS_HUNTED;
chrome.runtime.sendMessage({ 
        message: "get__OPS_HUNTED"
      }, response => {
      if (response.message === 'success') {
	OPS_HUNTED = response.payload;
	var div = document.getElementById("op2op");
	div.innerHTML = 'No candidates. Ensure that "Enable Needed Ops" option is on, then stats get populated when the Re-Spot, QSY, or QSL buttons are used (even if a spot is not created).';
	var divExport = document.getElementById("op2op__export");
	divExport.innerHTML = '';
	//console.log( OPS_HUNTED);
	if(Object.keys(OPS_HUNTED).length){
	    div.innerHTML = '';
	    var cols = ["#QSOs", "Callsign", "POTA UserID", "Other Callsigns"];
	    div      .append( cols.join("\t") + "\n" );
	    divExport.append( cols.join(",")  + "\n" );
	    // note: older cached date might not have "bio"
	    Object.keys(OPS_HUNTED)
		.filter( call => ! OPS_HUNTED[call].bio || OPS_HUNTED[call].bio.callsign == call )
		.filter( call => OPS_HUNTED[call].ct >= 5 )
		.sort( (a,b) => { var aa=OPS_HUNTED[a].ct; var bb=OPS_HUNTED[b].ct; return aa<bb?1 : aa==bb ? 0 : -1 } ) // ORDER BY ct DESC
		.forEach( (call) => {
			var bio = OPS_HUNTED[call].bio || { "callsign": call, "id":'', "other_callsigns":[] };
			var values = [ OPS_HUNTED[call].ct, bio.callsign, bio.id, bio.other_callsigns.join(",") ];
	    		div      .append( values.join("\t") + "\n" );
			divExport.append( values.map(s=> s.toString().match(/,/) ? `"${s}"` : s ).join(",")  + "\n" );
		})
	    ;
	}
      }
});

  chrome.runtime.sendMessage({ message: "get__MYAWARDS_EARNED_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
      var MYAWARDS_EARNED = JSON.parse(cache.data) || {};
//  [ {"activeCallsign": "K2DW", "dateGranted": "2022-05-22T06:55:00", "awardName": "Silver Activator", "awardDescription": "Working from 20 different units", "badgeNum": null, "endorsements": "PHONE", "reference": null, "parkName": null, "operator": null, "radarDate": null, "additionalDetails": null}, ... ]	   
	var div = document.getElementById("earned");
	div.innerHTML = 'No data. Ensure that "Enable My Awards" option is on.';
	var divExport = document.getElementById("earned__export");
	divExport.innerHTML = '';
	var divExportJSON = document.getElementById("earned__exportjson");
	divExportJSON.innerText = JSON.stringify( MYAWARDS_EARNED['curr'] );
	if( MYAWARDS_EARNED['curr'] && MYAWARDS_EARNED['curr'].length ){
	    div.innerHTML = '';
	    var cols = [
		    "dateGranted"
		    , "activeCallsign"
		    , "awardName"
		    , "awardDescription"
		    , "badgeNum"
		    , "endorsements"
		    , "reference"
		    , "parkName"
		    , "operator"
		    , "radarDate"
		    , "additionalDetails"
	    ];
	    div      .append( cols.join("\t") + "\n" );
	    divExport.append( cols.join(",")  + "\n" );
	    MYAWARDS_EARNED['curr'].forEach( (row) => {
			var values = cols.map( (s) => row[s] );
	    		div      .append( values.join("\t") + "\n" );
			divExport.append( values.map(s=> s!=null && s.toString().match(/,/) ? `"${s}"` : s ).join(",")  + "\n" );
	    });
	}
    }
  });

