
//const cloneItems = (items) => items.map(item => Array.isArray(item) ? cloneItems(item) : item);

function sendChromeMessage( message, payload ){
  // chrome.runtime.sendMessage({ "message": message, "payload": payload }, response => { if(response.message === 'success'){} });
  chrome.runtime.sendMessage(
	  { "message": message, "payload": payload },
	  response => {
		  if(response.message === 'success'){
			  // do nothing
		  }else{
			console.log(`ERROR sendMessage '${message}'`, response);
			console.log( 'ERROR sendMessage()', message, response.message, response.error.message );
		  }
	  }
  );
}

function parseCookie(str){
  return str
    .split(';')
    .map(v => v.split('='))
    .reduce((acc, v) => {
      acc[decodeURIComponent(v[0].trim())] = decodeURIComponent(v[1].trim());
      return acc;
    }, {});
}

function getPOTASettings(){
  var c = parseCookie(document.cookie);
  var tokenKey = Object.keys(c).find(x => x.match( /^CognitoIdentityServiceProvider\..+\.idToken$/ ) );
  // CognitoIdentityServiceProvider.7hluqct0n2nckib7i7sd5753oa.Google_115546631252865189044.idToken
  var TOKEN = c[tokenKey];
  if( ! TOKEN ){
    console.log("POTA api token not found");
    console.log('COOKIE', c);
  }
  var potaSettings = JSON.parse(c.POTA_SETTINGS); // callsign, bandFilter, userStats, darkMode, tableView
  potaSettings.tokenKey = tokenKey;
  return { "apiToken": TOKEN, "potaSettings": potaSettings };
}

function setOptionsDefaults( options ){
        options.qsyConfig.dataMode ||= 'USB';
        options.qsyConfig.cwMode ||= 'CW';
	if( ! options.hasOwnProperty('enableNeededOps') ){
	  options.enableNeededOps = true;
	}
	if( ! options.hasOwnProperty('enableNeededLocations') ){
	  options.enableNeededLocations = true;
	}
	if( options.enableNeededLocations && options.enableNeededWAS ){
	  // Locations takes precedence (and includes WAS by definition), so treat WAS as disabled.
	  options.enableNeededWAS = false;
	}
	if( ! options.hasOwnProperty('enableSpotFilters') ){
	  options.enableSpotFilters = true;
	}
	if( ! options.hasOwnProperty('enableMyAwards') ){
	  options.enableMyAwards = true;
	}
	return options;
}

///////////////////////////////////////////////////////

function youngerThan( t, ageHours ){
  var millis = Date.now() - t;
  var hrs = millis / 1000 / 60 / 60;
  //hrs = Math.floor(hrs);
  return hrs <= ageHours;
}

function band2Mhz (band) {
	var match = band.match( /(\d+)(\D+)/ );
	var mhz   = match[1];
	var units = match[2];
	if( units == 'CM' ){
		mhz /= 100.0
	}
	return mhz;
}


function compareBands(a,b){
	var aa = band2Mhz(a);
	var bb = band2Mhz(b);
	return aa<bb ? -1 : aa==bb ? 0 : 1
}

