
var session_info = getPOTASettings();
var potaSettings = session_info.potaSettings;
var TOKEN = session_info.apiToken;
var THEMECLASS = potaSettings.darkMode ? 'theme--dark' : 'theme--light';
var MYCALL = potaSettings.callsign;
console.log("MYCALL: ", MYCALL);

sendChromeMessage("set__MYCALL", MYCALL);
sendChromeMessage("set__TOKEN", TOKEN);

var MAINTABLE;
var CARDMODE;
var LISTMODE;
var DARKMODE;

var OPTIONS = null;
var LATESTVER = '';
var VERSION_CHECK = '';

function detectLayout() {
  MAINTABLE = document.querySelector('div.v-data-table__wrapper table tbody');
  CARDMODE = false;
  LISTMODE = true;
  if( MAINTABLE == null ){
	MAINTABLE = document.querySelector('div.layout.row.wrap');
	CARDMODE = true;
	LISTMODE = false;
  }
  DARKMODE = MAINTABLE.closest("div.theme--dark") ? true : false;
}
detectLayout();


chrome.runtime.sendMessage({ 
        message: "get__options"
      }, response => {
      if (response.message === 'success') {
	OPTIONS = setOptionsDefaults( response.payload );
	MAINTABLE.append(" "); // touch, to trigger initial update
      }
});

var WAS_HUNTED = null;
var PARKS_HUNTED = null;
var ACTIVATIONS = null;
var N1CC_HUNTED = null;
var LOCATIONS_HUNTED = null;

if( MYCALL){
  ////////
  chrome.runtime.sendMessage({ message: "get__LOCATIONS_HUNTED_cache" }, response => {
    if (response.message === 'success') {
	var cache = response.payload;
	LOCATIONS_HUNTED = cache.data;	// use cached
	MAINTABLE.append(" "); // touch, to trigger initial update
    }
  });  // get__LOCATIONS_HUNTED_cache
  ////////
  chrome.runtime.sendMessage({ message: "get__WAS_HUNTED_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
	WAS_HUNTED = cache.data;	// use cached
	MAINTABLE.append(" "); // touch, to trigger initial update
    }
  });  // get__WAS_HUNTED_cache
  ////////
  chrome.runtime.sendMessage({ message: "get__PARKS_HUNTED_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
	PARKS_HUNTED = cache.data;	// use cached
	MAINTABLE.append(" "); // touch, to trigger initial update
    }
  });  // get__PARKS_HUNTED_cache
  ////////
  chrome.runtime.sendMessage({ message: "get__N1CC_HUNTED_cache" }, response => {
    if (response.message === 'success') {
      var cache = response.payload;
      N1CC_HUNTED = ( cache ? cache.data : null ) || [];
	MAINTABLE.append(" "); // touch, to trigger initial update
    }
  });  // get__N1CC_HUNTED_cache
  ////////
} // if MYCALL




var observer;
if( observer == null ){
observer = new MutationObserver(mutations => {
    if( document.location.hash == "#/" ){
	console.log("Switched to SPOTS page");
	document.location.reload();
	return;
    }
    if( document.location.hash.match("#/profile/.+") ){
	console.log("Switched to PROFILE page");
	document.location.reload();
	return;
    }
    if( document.location.hash != "#/activations" ){
	console.log("NO LONGER ON ACTIVATIONS PAGE");
	return;
    }

    if( OPTIONS == null
		|| WAS_HUNTED == null
		|| LOCATIONS_HUNTED == null
		|| PARKS_HUNTED == null
		|| N1CC_HUNTED == null
    	){
	    // skip while still loading/initializing the async-fetch of dependencies
	    console.log("LOADING:"
		, 'OPTIONS: '      + (OPTIONS      ? 'Y' : '-')
		, 'WAS_HUNTED: '   + (WAS_HUNTED   ? 'Y' : '-')
		, 'LOCATIONS_HUNTED: ' + (LOCATIONS_HUNTED   ? 'Y' : '-')
		, 'PARKS_HUNTED: ' + (PARKS_HUNTED ? 'Y' : '-')
		, 'N1CC_HUNTED: '  + (N1CC_HUNTED  ? 'Y' : '-')
	    );
	    return;
    }

    observer.disconnect(); // turn observer off;


    var rows = LISTMODE
		? MAINTABLE.rows
		: Array.from( MAINTABLE.querySelectorAll('div.v-card.v-sheet') )
    ;

    for (let row of rows) {
      var cells = LISTMODE ? row.cells : Array.from( row.querySelectorAll("div.v-list-item") );
      var objs = {
	call: (LISTMODE ? cells[2]
		: ( row.querySelector("div.v-card__title.title a")
			||  row.querySelector("div.v-card__title.title span span") // User Stats mode
		) ),
	park_num:	(LISTMODE ? cells[3] : row.querySelector("div.v-card__title.title span") ),
	park_name:	(LISTMODE ? cells[3] : cells[0] ),
	park_region:	(LISTMODE ? cells[4] : cells[1] ),
	comments:	(LISTMODE ? cells[6] : cells[5] ),
      };

      if( !objs.call ) {
            console.log("ERROR -- no objs.call", objs);
	    continue;
      }
      var call = objs.call.innerText.trim();
      var park_num = objs.park_num.innerText.trim();
      var park_name = objs.park_name.innerText.trim().replaceAll('"',"'"); // replace double quotes with single quote
	    	// todo escape a "&"
      park_name = park_name.replace(/^\S+\s+/, ''); // strip park number of of front
      var park_region = objs.park_region.innerText.replace(/\n.+/,'').trim();
      park_region = park_region.replace(/(0|\d+\/\d+)$/,'').trim(); // CARDMODE hack
      var park_program = park_region.replace(/-.+/,'');
      if( LISTMODE ){
	      park_num = park_num.replace(/\s.+/, '');
      }
      if( CARDMODE ){
	      park_num = park_num.replace(/.+ @\s*/, '');
	      park_name = park_name.replace(/^[^,]+,\s*/, '');
      }


    if( ! objs.park_num.innerHTML.match(/BADGE_HOLDER/) ){
	  objs.badges = document.createElement('div');
	  objs.badges.setAttribute('data-marker','BADGE_HOLDER');
	  objs.badges.classList.add('v-badge__wrapper');
	  objs.badges.style.position='absolute';
	  if( LISTMODE ){
	    objs.badges.style.top='30px';
	    objs.badges.style.left='20px';
	  }
	  if( CARDMODE ){
	    objs.badges.style.display = 'contents';
	  }
	  objs.badges.style.fontFamily='monospace';
	  objs.badges.innerHTML = '';
	  objs.park_num.append(objs.badges);
    }else{
	  objs.badges = objs.park_num.querySelector('[data-marker="BADGE_HOLDER"]');
    }

    ///////////////////////////////////////

//-------------------------------------
    if( OPTIONS.enableNeededLocations && ! objs.park_region.innerHTML.match(/LOCATIONS_HUNTED/) ){
      var loc = park_region.replace(/,.+/,'');
      if(LOCATIONS_HUNTED.length ){
        var parkWorked = PARKS_HUNTED.find( x => x.reference === park_num );
        var hunted = LOCATIONS_HUNTED.find( x => x.locationDesc === loc );
		// keys: locationDesc, locationId, locationName, numParksActivated, numParksAvailable, toGo
//if Region not found as a Location, then "0" warning badge;  else if new-park then accent badge with the numParksActivated / numParksAvailable count.
	var label = hunted == null ? "0"
	      	: hunted.numParksActivated + "/" + hunted.numParksAvailable
	      ;
	var title = hunted == null ? "New needed location"
	      	: hunted.numParksActivated + "/" + hunted.numParksAvailable + " references worked for this location"
	      ;
        if( ! parkWorked ){ // new park#
//console.log('NEEDED', park_region, park_num, call, hunted);
	  var badge = document.createElement('span');
	  badge.setAttribute('data-marker','LOCATIONS_HUNTED');
	  badge.classList.add('v-badge__wrapper');
	  if( LISTMODE ){
	    badge.style.position='relative';
	    badge.style.top='15px';
	    badge.style.left='-15px';
	  }else{
	    badge.style.position='absolute';
	    badge.style.top='0px';
	    badge.style.left='35px';
	  }
	  badge.style.fontFamily='monospace';
	  badge.innerHTML = `<span class="v-badge__badge warning" title="${title}">${label}</span>`;
	  objs.park_region.append(badge);
        }
      }
    } // OPTIONS.enableNeededLocations

//-------------------------------------
    if( OPTIONS.enableNeededWAS && ! objs.park_region.innerHTML.match(/WAS_HUNTED/) ){
      var state = park_region.replace(/,.+/,'');
      if(WAS_HUNTED.length && state.match(/^US-..$/) && state != 'US-VI' ){
        var hunted = WAS_HUNTED.find( x => x.locationDesc === state );
        if( hunted == null ){
//console.log('NEEDED', park_region, park_num, call, hunted);
	  var badge = document.createElement('span');
	  badge.setAttribute('data-marker','WAS_HUNTED');
	  badge.classList.add('v-badge__wrapper');
	  if( LISTMODE ){
	    badge.style.position='relative';
	    badge.style.top='10px';
	    badge.style.left='-5px';
	  }else{
	    badge.style.position='absolute';
	    badge.style.top='0px';
	    badge.style.left='35px';
	  }
	  badge.style.fontFamily='monospace';
	  badge.innerHTML = `<span class="v-badge__badge warning">WAS</span>`;
	  objs.park_region.append(badge);
        }
      }
    } // OPTIONS.enableNeededWAS

//-------------------------------------
    if( OPTIONS.enableNeededParks && ! objs.park_num.innerHTML.match(/PARKS_HUNTED/) ){
      if(PARKS_HUNTED.length){
        var hunted = PARKS_HUNTED.find( x => x.reference === park_num );
	var badge = document.createElement('span');
	badge.setAttribute('data-marker','PARKS_HUNTED');
	badge.classList.add('v-badge__badge');
	badge.style.position = 'relative';
	badge.style.marginRight = '5px';
        if( hunted != null ){
	  badge.classList.add(
		  hunted.qsos >= 20 ? 'grey'
		:                     'accent'
	  );
	  badge.setAttribute('title', `Total QSOs with ${park_num}`);
	  badge.innerHTML = `${hunted.qsos}`;
          objs.badges.append(badge);
        }else if( ! OPTIONS.enableNeededLocations ){
	  badge.classList.add('warning');
	  badge.setAttribute('title', `No QSOs with ${park_num}`);
	  badge.innerHTML = `0`; // atno
          objs.badges.append(badge);
        }
      }
    } // OPTIONS.enableNeededParks

//-------------------------------------


  } // rows	    


    observe(); // turn back on 
}); // new MutationObserver
}

var observe = ()=> {
  observer.observe(MAINTABLE, {
    childList: true,
    characterData: true,
    subtree: true,
  });
};
observe();
MAINTABLE.append(" "); // touch, to trigger initial update
	
